class Config:
    """
    Config class for model parameters and settings.
    """
    granularity1 = 'channel'
    granularity2 = "global_category"

    groupby_columns_input = ['channel', 'global_category', 'survey_week']

    drop_columns_input = ["sales", 'channel', 'global_category', "survey_week"]

    groupby_agg_column1 = 'sales'
    groupby_agg_column2 = 'volume'
    ## XGBoost model parameters
    xg_boost_tuning_dict = {
        "True": {
            "max_depth": list(range(3, 10 + 1)),
            "learning_rate": [0.3, 0.2, 0.1, 0.05],
            "n_estimators": list(range(100, 300 + 1, 20)),
            "gamma": [0, 0.1, 0.01, 0.001],
            "subsample": [0.9, 0.8, 0.7],
            "colsample_bytree": [0.9, 0.8, 0.7],
            "colsample_bylevel": [0.9, 0.8, 0.7],
            "scale_pos_weight": [0.9, 0.8, 0.7],
            "importance_type": ['gain', 'weight', 'cover', 'total_gain', 'total_cover']
        },
        "False": {
            "n_estimators": 500,
            "learning_rate": 0.05,
            "max_depth": 6,
            "n_jobs": 1,
            "alpha": 0.1,
        }
    }
    linear_regression_tuning_dict = {
        "True": {
            "fit_intercept": [True, False],
            "copy_X": [True, False],
            "n_jobs": [None, -1, 1, 2, 3, 4]
        },
        "False": {
            "fit_intercept": True,
            "copy_X": True,
            "n_jobs": None
        }
    }
    # Define the parameter grid for linear gam 
    param_grid_gam = {
        'lam': [0.001, 0.01, 0.1, 1, 10, 100, 1000],  # Regularization parameter
        'n_splines': [5, 10, 20, 30, 40],  # Number of splines
        'spline_order': [3, 4, 5],  # Order of the splines
        'max_iter': [100,150]
    }
    model_parameters_dict = {
        "xg_boost": xg_boost_tuning_dict,
        "gam": param_grid_gam,
        "linear_regression": linear_regression_tuning_dict
    }
    tuning = True
    # Include the set of models that we want to experiments for each stage - treatment, outcome and residual- ["xgboost", "Linear GAM", "linear regression"]
    model_treatment_type_list = [ "Linear GAM", "linear regression"]
    model_outcome_type_list = ["xgboost", "Linear GAM", "linear regression"]
    model_residual_type_list = ["xgboost", "Linear GAM", "linear regression"]
    # Include all features which is used for baseline calculation 
    baseline_features = ['EDV_Price', 'Discount']
    # Primary feature for baseline estimation
    baseline_primary_feature = 'Discount'
    # Define the outcome column here for our causal modelling
    outcome_col = 'volume'
    # Auto configurable feedback on (confounder,treatment) pairs for each category .
    # This is the section which defines confounder, treatment pairs that our causal model uses to construct DAGs.
    feedbacks = {
        "Chocolate": [
            ('MW Share of Display %Secondary Location', 'Permanent Secondary Displays MW Top SKUs availability %Secondary Location'),
            ('MW Share of Shelf %Main Aisle', 'MW SKUs availability\xa0Main Aisle'),
            ('MW SKUs availability\xa0Transaction Zone', 'MW Share of Shelf %Transaction Zone'),
            ('MW SKUs availability\xa0Transaction Zone', 'Transaction zone\xa0Transaction Zone'),
            ('MW SKUs availability\xa0Main Aisle', 'MW Share of Shelf %Main Aisle'),
            ('MW Share of Shelf %Transaction Zone', 'MW SKUs availability\xa0Transaction Zone'),
        ],
        "Gum": [
            ('MW Share of Shelf %Main Aisle', 'MW SKUs availability\xa0Main Aisle'),
            ('MW SKUs availability\xa0Transaction Zone', 'MW Share of Shelf %Transaction Zone'),
            ('MW SKUs availability\xa0Transaction Zone', 'Transaction zone\xa0Transaction Zone'),
            ('MW SKUs availability\xa0Main Aisle', 'MW Share of Shelf %Main Aisle'),
            ('MW Share of Shelf %Transaction Zone', 'MW SKUs availability\xa0Transaction Zone'),
        ],
        "Fruity Confections": [
            ('MW Share of Shelf %Main Aisle', 'MW SKUs availability\xa0Main Aisle'),
            ('MW SKUs availability\xa0Transaction Zone', 'MW Share of Shelf %Transaction Zone'),
            ('MW SKUs availability\xa0Transaction Zone', 'Transaction zone\xa0Transaction Zone'),
            ('MW SKUs availability\xa0Main Aisle', 'MW Share of Shelf %Main Aisle'),
            ('MW Share of Shelf %Transaction Zone', 'MW SKUs availability\xa0Transaction Zone'),
        ],
        "Health & Wellbeing": [
            ('Display Secondary Location', 'MW SKUs availability\xa0Main Aisle'),
        ],
        "Ice Cream": [
            ('Display Secondary Location', 'MW SKUs availability\xa0Secondary Location'),
        ]
    }
    # Elimination of causal relationships from business feedback
    elimination = {"Chocolate": [('MW Share of Display %Secondary Location', 'Transaction zone\xa0Transaction Zone'),
                                 ('MW Share of Display %Secondary Location', 'MW SKUs availability\xa0Main Aisle')]}
    test_size = 0.2
    random_state = 60
    # Overall category list for UAE -['Gum', 'Health & Wellbeing', 'Chocolate', 'Fruity Confections', 'Ice Cream']
    category_list = ['Chocolate']
    # Overall channel list for UAE -['Express A', 'Hypers A', 'Express B']
    channel_list = ['Express A']
    # Category wise DAG minimum size that we want to iterate
    dag_type_min_len = {
        "Chocolate": 4,
        "Gum": 3,
        "Fruity Confections": 3,
        "Health & Wellbeing": 1,
        "Ice Cream": 1
    }
    # Option to choose combinations / all counfounder treatment feedback iterations -["individual_combinations","all"]
    iterations_type = "all"
    # Category wise threshold for filtering all DAGs -Business feedback and Blended or union approach
    dag_type_len = {
        "Chocolate": 4,
        "Gum": 3,
        "Fruity Confections": 3,
        "Health & Wellbeing": 1,
        "Ice Cream": 1
    }
    # exception market-channel
    exception_cut = [('Hypers A', 'Ice Cream')]
    correlation_pair_size = {
        "Chocolate": 3,
        "Gum": 3,
        "Fruity Confections": 3,
        "Health & Wellbeing": 1,
        "Ice Cream": 1
    }
    # Weight parameters for selection of best model
    weight_test_r2 = 0.7
    weight_sensitivity_test_treatment_r2 = 0.2
    weight_sensitivity_test_random_confounder_r2 = 0.1
    # configuration to consider business alone / blended or union approach -["Blended","Business"]
    type_of_model = "Blended"
